function besa_channels=eeglab2besa( EEG )
% EEGLAB2BESA saves EEG struct from EEGLAB to besa_channels struct 
% which is compatible with BESA Research standard and can be exported to
% BESA Research by BESA_SAVE funtion if needed
%
% Parameters:
%     [EEG]
%         A structure that was generated by EEGLAB. Note that events need
%         to have at least fields 'latency' and 'type'
% 
% Return:
%     [besa_channels]
%         BESA standard struct
% 
% 

% Copyright (C) 2019, BESA GmbH
%
% File name: BESA_SAVE.m
%
% This file is part of MATLAB2BESA.
%
%    MATLAB2BESA is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    MATLAB2BESA is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with MATLAB2BESA. If not, see <http://www.gnu.org/licenses/>.
%
% Author: Mateusz Rusiniak
% Created: 2019-04-23
    index=strfind(EEG.comments,'Original file: ');
    
    besa_channels.datafile=EEG.comments(index:numel(EEG.comments));
    besa_channels.channelcoordinates=zeros(EEG.nbchan,9);
    for chan=1:EEG.nbchan
        besa_channels.channeltypes{chan}=EEG.chanlocs(chan).type;
        besa_channels.channellabels{chan}=EEG.chanlocs(chan).labels;
        besa_channels.channelunits{chan}='V';
        if (~isempty(EEG.chanlocs(chan).Y)&&...
            ~isempty(EEG.chanlocs(chan).X)&&...
            ~isempty(EEG.chanlocs(chan).Z))
            besa_channels.channelcoordinates(chan,1)=- EEG.chanlocs(chan).Y;
            besa_channels.channelcoordinates(chan,2)=- EEG.chanlocs(chan).X;
            besa_channels.channelcoordinates(chan,3)=- EEG.chanlocs(chan).Z;
        else
             besa_channels.channelcoordinates(chan,1:3)=0;
        end    
        besa_channels.channelcoordinates(chan,4:9)=0;
    end
    besa_channels.montage='';
    besa_channels.filters='';
    besa_channels.samplingrate=EEG.srate;
    besa_channels.HSPcoordinates=[0,0.077036164700985,0;-0.077036164700985,0,0;0.077036164700985,0,0];
    besa_channels.HSPtypes={'Fiducial','Fiducial','Fiducial'};
    besa_channels.HSPlabels={'FidNz','FidT9','FidT10'};
    besa_channels.headcenter=[0,0,0.0359225533902645];
    besa_channels.headradius=0.0850;
    besa_channels.electrodethickness=0;
    besa_channels.structtype='besa_channels';
    if (numel(EEG.epoch)>0||~isempty(EEG.condition))
        if ~isempty(EEG.condition)
            besa_channels.datatype='Segment';
        else
            besa_channels.datatype='Epoched_Data';
        end
        for epoch=1:numel(EEG.epoch)
            besa_channels.data(epoch).amplitudes=double(EEG.data(:,:,epoch)');
            besa_channels.data(epoch).latencies=double(EEG.times);
            if exist('EEG.event(epoch).timeoffsetsecs','var')
                besa_channels.data(epoch).timeoffsetsecs=EEG.event(epoch).timeoffsetsecs;
            end
            for event=1:numel(EEG.epoch(epoch).event)
                
                if exist('EEG.event(epoch).type','var')
                    besa_channels.data(epoch).event(event).type={EEG.event(EEG.epoch(epoch).event(event)).besatype};
                else
                    besa_channels.data(epoch).event(event).type={'Trigger'};
                end
                besa_channels.data(epoch).event(event).label={EEG.event(EEG.epoch(epoch).event(event)).type};
                besa_channels.data(epoch).event(event).latencyofpartner=0;
                besa_channels.data(epoch).event(event).latency=(EEG.event(EEG.epoch(epoch).event(event)).latency+EEG.xmin *(EEG.srate)-1-(epoch-1)*EEG.pnts)*1000/EEG.srate;
           
                if strcmp( besa_channels.datatype,'Segment')
                     besa_channels.data(epoch).event(event).prestimulusms=-besa_channels.data(1).latencies(1);
                else
                    besa_channels.data(epoch).event(event).timesincemidnightms=0;
                end
             end
        end
    else
        besa_channels.datatype='Raw_Data';
        besa_channels.amplitudes=double(EEG.data');
        besa_channels.latencies=EEG.times;
        for event=1:numel(EEG.event)
            if exist('EEG.event(event).besatype','var')
                besa_channels.events(event).type = {EEG.event(event).besatype};
            else
                besa_channels.events(event).type ={'Trigger'};
            end
            besa_channels.events(event).label ={EEG.event(event).type};
            besa_channels.events(event).latencyofpartner=0;
            besa_channels.events(event).latency =(EEG.event(event).latency-1)*1000/EEG.srate;
            besa_channels.events(event).timesincemidnightms=0;
        end
        
    end
end

